C
C------------------------------------------------------
C
C     Problem:    DISORDER
C
C     Date:       23.11.2001
C
C------------------------------------------------------
C
*     CONINT pulse
      0.0       1.0
      0.020833  0.0
      0.5       1.0
      0.520833  0.0
      1.0       1.0
      1.020833  0.0
      1.5       1.0
      1.520833  0.0
      2.0       1.0
      2.020833  0.0
      2.5       1.0
      2.520833  0.0
      3.0       1.0
      3.020833  0.0
      3.5       1.0
      3.520833  0.0
      4.0       1.0
      4.020833  0.0
      4.5       1.0
      4.520833  0.0
      5.0       1.0
      5.020833  0.0
      5.5       1.0
      5.520833  0.0
      6.0       1.0
      6.020833  0.0
      6.5       1.0
      6.520833  0.0
      7.0       1.0
      7.020833  0.0
      7.5       1.0
      7.520833  0.0
      8.0       1.0
      8.020833  0.0
      8.5       1.0
      8.520833  0.0
      9.0       1.0
      9.020833  0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -k1*y1 + k2*pulse(t)
C
*     FUNCTION y2_t
      y2_t = k1*y1 - k3*y2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      if (t.eq.0) then
        y1_0 = 0
      else
        y1_0 = y1
      endif
C
*     FUNCTION y2_0
      if (t.eq.0) then
        y2_0 = 0
      else
        y2_0 = y2
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

