C
C------------------------------------------------------
C
C     Problem:    DISLIQU
C 
C     Date:       22.3.2001
C
C------------------------------------------------------
C  
*     INTEGER CONSTANT
      N   = 6
      N_2 = N-2
C
C------------------------------------------------------
C  
*     SET OF INDICES
      ISET = 1..N
      ISET2 = 1..N_2
C
C------------------------------------------------------
C  
*     TABLE V_ll(i), i IN ISET
      1   62.4
      2   40.2
      3   40.2
      4   40.2
      5   60.3
      6   19.3
C    
*     TABLE eps(i), i IN ISET
      1   0.0211
      2   0.0438
      3   0.0666
      4   0.0438
      5   0.0901
      6   0.1022
C     
*     TABLE vg(i), i IN ISET
      1   0.004
      2   0.0078
      3   0.0116
      4   0.0153
      5   0.0171
      6   0.0170
C    
*     TABLE vfl(i), i IN ISET
      1   0.0087
      2   0.0087
      3   0.0086
      4   0.0086
      5   0.0086
      6   0.0085
C
C------------------------------------------------------
C  
*     REAL CONSTANT
      V_pkt_fl = 628.6/3600
      DI = 5.06
      A_reac = 3.1416/4*DI**2
      a_rel = 0.1
      c_fl_ein = 10000
      t_ein = 0
      t_aus = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      KF
      c_fl(i), i IN ISET
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:

*     FUNCTION dcfl_dt(i), i IN ISET
      IF (t.GT.t_ein.AND.t.LE.t_aus) THEN
        c_fl_ein0 = c_fl_ein
      ELSE
        c_fl_ein0 = 0.0
      ENDIF
      IF (i.EQ.1) THEN
        V_ret1= KF*vg(1)**0.2*a_rel/(1+0.01*vg(1)/a_rel)
        dcfl_dt(I) = vfl(1)*A_reac/(1-eps(1))/V_ll(1)*
     /            (c_fl(2)-c_fl(1))
     /       - V_ret1/(1-eps(1))/V_ll(1)*c_fl(1)
     /       + V_ret1/(1-eps(1))/V_ll(1)*c_fl(2)
      ENDIF
      IF (i.GT.1.AND.i.LT.N) THEN
      V_retI = KF*vg(i)**0.2*a_rel/(1+0.01*vg(i)/a_rel)
      V_retI_1 = KF*vg(i-1)**0.2*
     /             a_rel/(1+0.01*vg(i-1)/a_rel)
      dcfl_dt(I) = vfl(i)*A_reac/(1-eps(i))/V_ll(i)*
     /           (c_fl(i+1)-c_fl(i))
     /       - V_retI/(1-eps(i))/V_ll(i)*c_fl(i)
     /       + V_retI_1/(1-eps(i))/V_ll(i)*c_fl(i-1)
     /       - V_retI_1/(1-eps(i))/V_ll(i)*c_fl(i)
     /       + V_retI/(1-eps(i))/V_ll(i)*c_fl(i+1)
      ENDIF
      IF (i.EQ.N) THEN
        V_retN_1=KF*vg(i-1)**0.2*a_rel/(1+0.01*vg(i-1)/a_rel)
        dcfl_dt(I) = vfl(i)*A_reac/(1-eps(i))/V_ll(i)*
     /              (c_fl_ein0-c_fl(i))
     /      + V_retN_1/(1-eps(i))/V_ll(i)*c_fl(i-1)
     /      - V_retN_1/(1-eps(i))/V_ll(i)*c_fl(i)
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c_fl_0(i), i IN ISET
      c_fl_0(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fl_aus(i), i in ISET
      c_fl_aus(i)  = c_fl(i)
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C








