C
C------------------------------------------------------
C
C     Problem:    DIODE
C
C     Date:       15.03.2001
C
C------------------------------------------------------
C
*     LININT u
      0.0    1.0
      1.04   1.0
      1.71  -1.0
      2.88  -1.0
      3.7    0.2
      5.0    0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p, a, x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x2
C
*     FUNCTION x2_t
      x2_t = -x1 + x2*(1.4 - p*x2**2) + 4*a*u(t)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = -5
C
*     FUNCTION x2_0
      x2_0 = -5
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION u_fit
      u_fit = u(t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g1
c      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
