C
C------------------------------------------------------
C
C     Problem:    DIMER
C
C     Date:       02.10.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      a0 = 2
      b0 = 3
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, c, d, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION c_t
      w = k3*c*c-k4*d
      c_t = k1*(a0-c-2*d)*(b0-c-2*d)-k2*c-2*w
C
*     FUNCTION y2_t
      y2_t = w
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c_0
      c_0 = 0
C
*     FUNCTION d_0
      d_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fit
      c_fit = c
C
*     FUNCTION d_fit
      d_fit = d
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

