C
C------------------------------------------------------
C
C     Problem:    DIFF_P
C
C     Date:       7.2.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V1 = 100.0
      V2 = 50.0
      F  = 500.0
      y0 = 1000.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      K, k0, D, u, u_r, u_rr, y, z, fx, fx_r, r, t
C
C------------------------------------------------------
C
*     FUNCTION flux
      flux = r*u_r
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      u_t = D*fx_r/r
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 0.0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C 
*     FUNCTION y_t
      y_t = -K*y + F*D*fx
C
*     FUNCTION z_t
      z_t = -F*D*fx
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y_0
      y_0 = y0
C
*     FUNCTION z_0
      z_0 = 0.0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_r1
      u_r1 = y*K/V1
C
*     FUNCTION u_r2
      u_r2 = z*K/V2
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit_1
      fit_1 = y/V1
C
*     FUNCTION fit_2
      fit_2 = z/V2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
