C
C------------------------------------------------------
C
C     Problem:    DIFFUS_L
C
C     Date:       22.12.97
C
C------------------------------------------------------
C
*     REAL CONSTANTS
      u0 = 1
      uL = 0
      uR = 0
      xL = 0
      xR = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. Laplace variable (s) corresponding to time
C        variable
C
*     VARIABLE
      D, x, s
C
C------------------------------------------------------
C
C   - Functions defining fitting criteria in the Laplace
C     space:
C
*     FUNCTION U
      b  = sqrt(s/D)
      c  = u0/s
      n  = exp(-b*(xR - xL)) - exp(b*(xR - xL))
      a1 = ((c - uL)*exp(b*xR) - (c - uR)*exp(b*xL))/n
      a2 = ((c - uR)*exp(-b*xL) - (c - uL)*exp(-b*xR))/n
      U  = a1*exp(-b*x) + a2*exp(b*x) + c
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
