C
C------------------------------------------------------
C
C     Problem:    DIFFREA1
C
C     Date:       01.07.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      h      = 0.001
      thetaB = 0.1                      
      CA0    = 1
      Sex    = 0.1353
      R      = 0.000082057
      Temp   = 445
      V      = 0.00703 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      k, Ek, Deff, a1, a2, a3, a4, a5, a6, X, X_z, X_zz, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION X_t
      X_t = Deff/h**2*X_zz + k*(1 - thetaB/Ek - (1 + 1/Ek)*X)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION X_0
      X_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C           
*     FUNCTION X_z_left
      PA_t =  a1*exp(-a2*t**2 - a3*t)*(-2*a2*t - a3) + 2*a4*t + a5
      X_z_left = -PA_t*V*h/(R*Temp*Sex*Deff*CA0)
C
*     FUNCTION X_z_right
      X_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      PA = a1*exp(-a2*t**2 - a3*t) + a4*t**2 + a5*t + a6
      fit = PA
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

