C
C------------------------------------------------------
C
C     Problem:    DIFFREA
C
C     Date:       01.07.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      h = 1E-2
      thetaB = 0.001                      
      CA0 = 1
      Sex = 0.1353
      R = 0.000082057
      Temp = 445
      V = 0.00703 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (One
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      k, Ek, Deff, X, X_z, X_zz, PA, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION X_t
      X_t = Deff/h*X_zz + k*(1 - thetaB/Ek - (1 + 1/Ek)*X)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION X_0
      X_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION PA_t
      PA_t = -R*Temp/V*Sex*Deff*CA0*X_z
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION PA_0
      PA_0 = 52.5
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION X_left
      X_left = 0.01
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION X_z_right
      X_z_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = PA
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

