C
C------------------------------------------------------
C
C     Problem:    DIFFPT
C
C     Date:       16.3.2000
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k2 = 1
      C0 = 1
      a = -4
      b = 1
      s = 2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      k1, D1, D2, c, c_x, c_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION c2_t
      c2_t = D2*c_xx
C
*     FUNCTION c1_t
      c1_t = D1*c_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION c2_0
      if (abs(x-a).lt.s*b) then
        c2_0 = C0*exp(-((x-a)**2/b**2)**2)
      else
        c2_0 = 0
      endif
C
*     FUNCTION c1_0
      c1_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION c2_right
      c2_right = k2/k1*c
C
*     FUNCTION c1_right
      c1_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION c2_x_left
      c2_x_left = 0
C
*     FUNCTION c1_x_left
      c1_x_left = D2/D1*c_x
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit
      fit = c
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
