C
C------------------------------------------------------
C
C     Problem:    DIFDIST
C
C     Date:       12.02.01
C
C------------------------------------------------------
C 
*     SET OF INDICES
      IND=1..50
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      S0=50          
      V=5     
      XA0=0.2     
      XB0=0.3        
      XC0=0.1     
      XD0=0.4     
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ALA, ALB, ALC, ALD
      MA, MB, MC, MD, DA, DB, DC, DD, S, D, T 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION MAP
      IF (S.GT.0) THEN
        XA=MA/S
        XB=MB/S
        XC=MC/S
        XD=MD/S   
      ELSE
        XA=1E-10
        XB=1E-10
        XC=1E-10
        XD=1E-10
      ENDIF
      SUM1=ALA*XA+ALB*XB+ALC*XC+ALD*XD
      IF (SUM1.LT.1E-20) THEN
        SUM1=1E-20
      ENDIF
      YA=ALA*XA/SUM1
      YB=ALB*XB/SUM1
      YC=ALC*XC/SUM1
      YD=ALD*XD/SUM1
      MAP=-V*YA
C
*     FUNCTION MBP
      MBP=-V*YB
C
*     FUNCTION MCP
      MCP=-V*YC
C
*     FUNCTION MDP
      MDP=-V*YD
C
*     FUNCTION DAP
      DAP=V*YA
C
*     FUNCTION DBP
      DBP=V*YB
C
*     FUNCTION DCP
      DCP=V*YC
C
*     FUNCTION DDP
      DDP=V*YD
C
*     FUNCTION SP
      SP=-V
C
*     FUNCTION DP
      DP=V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION MA_0
      IF (T.LT.0.1) THEN
        MA_0=S0*XA0
      ELSE
        MA_0=MA+2
      ENDIF
C
*     FUNCTION MB_0
      IF (T.LT.0.1) THEN
        MB_0=S0*XB0
      ELSE
        MB_0=MB+3
      ENDIF
C
*     FUNCTION MC_0
      IF (T.LT.0.1) THEN
        MC_0=S0*XC0
      ELSE
        MC_0=MC+4
      ENDIF
C
*     FUNCTION MD_0
      IF (T.LT.0.1) THEN
        MD_0=S0*XD0
      ELSE
        MD_0=MD+5
      ENDIF
C
*     FUNCTION DA_0
      IF (T.LT.0.1) THEN
        DA_0=0
      ELSE
        DA_0=DA
      ENDIF
C
*     FUNCTION DB_0
      IF (T.LT.0.1) THEN
        DB_0=0
      ELSE
        DB_0=DB
      ENDIF
C
*     FUNCTION DC_0
      IF (T.LT.0.1) THEN
        DC_0=0
      ELSE
        DC_0=DC
      ENDIF
C
*     FUNCTION DD_0
      IF (T.LT.0.1) THEN
        DD_0=0
      ELSE
        DD_0=DD
      ENDIF
C
*     FUNCTION S_0
      IF (T.LT.0.1) THEN
        S_0=S0
      ELSE
        S_0=S
      ENDIF
C
*     FUNCTION D_0
      IF (T.LT.0.1) THEN
        D_0=0
      ELSE
        D_0=D
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION AvA
      IF (D.GT.0) THEN
        AvA=DA/D
      ELSE
        AvA=1
      ENDIF
C
*     FUNCTION AvB
      IF (D.GT.0) THEN
        AvB=DB/D
      ELSE
        AvB=1
      ENDIF
C
*     FUNCTION AvC
      IF (D.GT.0) THEN
        AvC=DC/D
      ELSE
        AvC=1
      ENDIF
C
*     FUNCTION AvD
      IF (D.GT.0) THEN
        AvD=DD/D
      ELSE
        AvD=1
      ENDIF
C
*     FUNCTION XAFIT
      IF (S.GT.0) THEN
        XA=MA/S
        XB=MB/S
        XC=MC/S
        XD=MD/S
      ELSE
        XA=0
        XB=0
        XC=0
        XD=0
      ENDIF
      XAFIT=XA
C
*     FUNCTION XBFIT
      XBFIT=XB
C
*     FUNCTION XCFIT
      XCFIT=XC
C
*     FUNCTION XDFIT
      XDFIT=XD
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G =...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
