C
C------------------------------------------------------
C
C     Problem:    DIAUXIA
C
C     Date:       01-07-16
C
C------------------------------------------------------
C
*     REAL CONSTANT
      YXS1 = 0.5
      YXS2 = 0.45
      KS1 = 0.01
      S10 = 10
      S20 = 10
      X0 = 0.1
      E10 = 1
      E20 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      rmax1, rmax2, KM1, KM2, K2, S1, S2, X, E1, E2, t 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S1_t
      S1_t = (-1/YXS1)*rmax1*(S1/(S1 + KM1))*X
C
*     FUNCTION S2_t
      S2_t = (-1/YXS2)*rmax2*(S2/(S2 + KM2))*(KS1/(KS1 + S1))*E2*X
C
*     FUNCTION X_t
      mi = rmax1*(S1/(S1 + KM1)) + rmax2*(S2/(S2 + KM2))
     /                                      *(KS1/(KS1 + S1))*E2
      X_t = mi*X
C
*     FUNCTION E1_t
      mi = rmax1*(S1/(S1 + KM1)) + rmax2*(S2/(S2 + KM2))
     /                                      *(KS1/(KS1 + S1))*E2
      E1_t = rmax1*(S1/(S1 + KM1)) - K2*E1 - mi*E1
C
*     FUNCTION E2_t
      mi = rmax1*(S1/(S1 + KM1)) + rmax2*(S2/(S2 + KM2))
     /                                      *(KS1/(KS1 + S1))*E2
      E2_t = rmax2*(S2/(S2 + KM2))*(KS1/(KS1 + S1))*E2 + K2*E1 - mi*E2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*        FUNCTION S1_0
         S1_0 = S10
C
*        FUNCTION S2_0
         S2_0 = S20
C
*        FUNCTION X_0
         X_0 = X0 
C
*        FUNCTION E1_0
         E1_0 = E10
C
*        FUNCTION E2_0
         E2_0 = E20
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*        FUNCTION S1_fit
         S1_fit = S1
C
*        FUNCTION S2_fit
         S2_fit = S2
C
*        FUNCTION X_fit
         X_fit = X
C
*        FUNCTION E1_fit
         E1_fit = E1
C
*        FUNCTION E2_fit
         E2_fit = E2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


