C
C------------------------------------------------------
C
C     Problem:    DIALYSI3
C
C     Date:       9.7.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      C0 = 0.511
      VD = 252  
      VA = 251000
      F = 254
      L = 0.042
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D1, D2, k, u, u_x, u_xx, q, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_p
      u1_p = D1*u_xx
C
*     FUNCTION u2_p
      u2_p = D2/L**2*u_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = C0
C
*     FUNCTION u2_0
      u2_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION q_p
      q_p = -D2*F/L*u_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION q_0
      q_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u2_left
      u2_left = k*u
C
*     FUNCTION u2_right
      u2_right = k*q/VA
C
C------------------------------------------------------
C
C   - Boundary and transition gradients first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u1_x_left
      u1_x_left = 0
C
*     FUNCTION u1_x_right
      u1_x_right = D2/D1*u_x/L
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = q
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
