C
C------------------------------------------------------
C
C     Problem:    DIALYSI2
C
C     Date:       9.7.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      C0   = 0.0276
      VD   = 252  
      VR   = 251000
      F    = 254
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D, k, u, u_x, u_xx, y, q, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_p
      u_p = D*u_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      u_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION y_p
      y_p = D*F*u_x
C
*     FUNCTION q_p
      q_p = -D*F*u_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y_0
      y_0 = C0*VD
C
*     FUNCTION q_0
      q_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_left
      u_left = y/VD*k
C
*     FUNCTION u_right
      u_right = q/VR*k
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = q
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
