C
C------------------------------------------------------
C
C     Problem:    DIABETES
C
C     Date:       25.03.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      s = 2
      a = 1.4
      b = 56
      dose = 5
      Kins = 0.030
      kp = 0.00134
      Fog = 45
      Kg = 92
      Bo = 140
      Go = 180
      GFR = 1.3
      Tm = 375
      Ax = 660
      k4 = 400
      Vi = 7.48
      Vg = 70
      vabs = 5
      P = 140
      ch = 20000
      time = 600
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k2, k3, k5, k6, k7, k8, y1, y2, y3, y4, y5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      if (t.lt.time) then
        y1_t = 0
      else
        y1_t = -k5*y1 - (t-time)*s*(a*dose + b)**s*dose/Vi
     /                    /((a*dose + b)**s + (t-time)**2)**2
      endif
C
*     FUNCTION y2_t
      if (t.lt.time) then
        y2_t = 0
      else
        y2_t = -k7*y2 + k6*y1
      endif
C
*     FUNCTION y3_t
      if (t.lt.time) then
        y3_t = 0
      else
        w = GFR*y3/Vg-Tm
        if (w.lt.0) then
          w = 0
        endif
        y3_t = -Ax*y2*y3/(Kg*Vg + y3) - kp*y3 
     /           - w + k2*y4 + Bo - k4*y2/(Kins + y2) - k3*y3/Vg
      endif
C
*     FUNCTION y4_t
      if (t.lt.time) then
        y4_t = 0
      else
        y4_t = -k2*y4 + k4*ch/(P + exp(Vabs/ch*(t-time)))
      endif
C
*     FUNCTION y5_t
      if (t.lt.time) then
        y5_t = 0
      else  
        y5_t = -k8*y5 + Ax*y2*y3/(Kg*Vg + y3)
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      if (t.lt.0.001) then
        y1_0 = 500
      else
        y1_0 = y1
      endif
C
*     FUNCTION y2_0
      if (t.lt.0.001) then
        y2_0 = 0
      else
        y2_0 = y2
      endif
C
*     FUNCTION y3_0
      if (t.lt.0.001) then
        y3_0 = Go*Vg
      else
        y3_0 = y3
      endif
C
*     FUNCTION y4_0
      if (t.lt.0.001) then
        y4_0 = 0
      else
        y4_0 = y4
      endif
C
*     FUNCTION y5_0
      if (t.lt.0.001) then
        y5_0 = 0
      else
        y5_0 = y5
      endif
C 
C------------------------------------------------------
C
C   - Fitting criteria:
C
C
*     FUNCTION y3_fit
      y3_fit = y3/Vg
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
