C
C------------------------------------------------------
C
C     Problem:    DFBLASER
C
C     Date:       08.01.2003
C
C------------------------------------------------------
C          
*     REAL CONSTANT
      pi         = 3.141592654
      q          = 1.60218E-19
      h          = 6.6256E-34
      c          = 2.99793E8
      lambda     = 0.00000131648
      nu         = c/lambda               
      V          = 1.2E-11
      rho        = 0.2
      tau_N      = 2.19E-9
      beta       = 0.99
      Nt         = 1.15E18
      N          = 2.51E18
      S          = 8e14       
      sc_g0      = 1E-6
      sc_n0      = 1
      sc_epsilon = 1E-17
      sc_tau_P   = 1E-12
C
C------------------------------------------------------
C          
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      g0, n0, epsilon, tau_P, t
C           
C------------------------------------------------------
C
C   - Fitting criteria:
C 
*     FUNCTION Y1                     
      Y1 = (sc_g0*g0*(S/(1+sc_epsilon*epsilon*S)) + 1/tau_N 
     /     - rho*sc_g0*g0*(N-Nt)
     /  *(1/((1+sc_epsilon*epsilon*S)**2)) + 1/(sc_tau_P*tau_P) 
     /     - 14544678326.685652)/14544678326.685652
C                      
*     FUNCTION Z1
      Z1 = (sc_g0*g0*(S/(1+sc_epsilon*epsilon*S))
     /                             *(1/(sc_tau_P*tau_P)) 
     /     + (beta-1)*((rho*sc_g0*g0)/tau_N)*(N-Nt)
     /                      *(1/((1+sc_epsilon*epsilon*S)**2)) 
     /     + (1/(sc_tau_P*tau_P*tau_N))   
     /     - 1913468974693887000000.0)/1913468974693887000000.0
C                      
*     FUNCTION Ith
      Ith = (q*V*((N/tau_N) + (sc_g0*g0*S*(N-Nt))
     /                       /(1+sc_epsilon*epsilon*S))   
     /     - 11e-3)/11e-3
C                      
*     FUNCTION P
      P = ((S*V*sc_n0*n0*h*nu)/(2*rho*sc_tau_P*tau_P)    
     /     - 9.1e-4)/9.1e-4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

