C
C------------------------------------------------------
C
C     Problem:     DEWPOINT
C
C     Date:        30.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      a1 = 7.62231
      a2 = 8.10765
      b1 = 1417.9
      b2 = 1750.29
      c1 = 191.15
      c2 = 235.0
      p1 = 1.7
      p2 = p1 - 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      w, x1, x2, Temp, c
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION f1
      x4 = 1 - x1
      x5 = 1 - x2
      x6 = 10**(a1 - b1/(c1 + Temp))
      x7 = 10**(a2 - b2/(c2 + Temp))
      x8 = 10**(p1*x4**2/(p1*x1/p2 + x4)**2)
      x9 = 10**(p1*x1**2/(x1 + p2*x4/p2)**2)
      x10 = 10**(p1*x5**2/(p1*x2/p2 + x5)**2)
      x11 = 10**(p1*x2**2/(x2 + p2*x5/p2)**2)     
      x12 = x6*x8/w
      x13 = x7*x9/w
      x14 = x6*x10/w
      x15 = x7*x8/w   
      if ((abs(x14-x12).gt.0.0000001).and.(x1.gt.0)) then
        x16 = (0.2*x14/x1 - x12)/(x14 - x12)
      else
        x16 = 0
      endif
      f1 = x12*x1 + x13*x2 - 1
C
*     FUNCTION f2
      f2 = x2*x14 - x1*x12
C
*     FUNCTION f3
      f3 = x4*(x16*x15 + (1 - x16)*x13) - c*x15
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION x1_0
      x1_0 = 0.02
C
*     FUNCTION x2_0
      x2_0 = 0.7
C
*     FUNCTION x3_0
      x3_0 = 100
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION Temp_fit
      Temp_fit = Temp
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION x6_fit
      x6_fit = x6
C
*     FUNCTION x7_fit
      x7_fit = x7
C
*     FUNCTION x8_fit
      x8_fit = x8
C
*     FUNCTION x9_fit
      x9_fit = x9
C
*     FUNCTION x10_fit
      x10_fit = x10
C
*     FUNCTION x11_fit
      x11_fit = x11
C
*     FUNCTION x12_fit
      x12_fit = x12
C
*     FUNCTION x13_fit
      x13_fit = x13
C
*     FUNCTION x14_fit
      x14_fit = x14
C
*     FUNCTION x15_fit
      x15_fit = x15
C
*     FUNCTION x16_fit
      x16_fit = x16
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



