C
C------------------------------------------------------
C
C     Problem:    DESIGN
C
C     Date:       10.02.98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      v, y, y_x, y_xx, f, f_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION flux
      flux = -v*y**2
C
*     FUNCTION T_p
      u = 1.45*sin(0.1+2.9*x)
      T_p = f_x - 0.3*y*(2+y)*u
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION y_0
      y_0 = 0.4*cos(pi*x) - 0.1
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION y_left
      if (t.lt.0.7) then
        y_left = 0.3
      else
        if (t.lt.1.7) then
          y_left = 0.5 - 0.2*cos(pi*(t-0.7)) 
        else
          y_left = 0.7
        endif
      endif
C     
*     FUNCTION y_right
      y_right = -0.5
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = y
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
