C
C------------------------------------------------------
C
C     Problem:    DENSITY
C
C     Date:       14.05.2004
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C                       
*     VARIABLE
      ml, mh, dens_Tc, Tc, g, b, T
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION density
      high = mh*(T-Tc) + dens_Tc
      lowlin = ml*(T-Tc) + dens_Tc
      curve = b*tanh(g*(Tc-T))
      if (T.lt.Tc) then
        density = curve + lowlin 
      else
        density = high
      endif  
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




