C
C------------------------------------------------------
C
C     Problem:    DEHYBENZ
C
C     Date:       08.10.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Kp1 = 0.242
      Kp2 = 0.428
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      r1 = k1*(y1**2 - y2*(2 - 2*y1 - y2)/(3*Kp1))
      r2 = k2*(y1*y2 - (1 - y1 - 2*y2)*(2 - 2*y1 - y2)/(9*Kp2))
      y1_t = -r1 - r2
C
*     FUNCTION y2_t
      y2_t = r1/2 - r2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = 1
C
*     FUNCTION y2_0
      y2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
