C
C------------------------------------------------------
C
C     Problem:    DEGRAD1
C
C     Date:       31.10.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      CA0 = 92.7 
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, CA, CB, CC, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION dCA_dt
      dCA_dt = -k1*CA
C
*     FUNCTION dCB_dt
      dCB_dt = k1*CA - k2*CB
C
*     FUNCTION dCC_dt
      dCC_dt = k2*CB - k3*CC
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CA_0
      CA_0 = CA0
C
*     FUNCTION CB_0
      CB_0 = 0
C
*     FUNCTION CC_0
      CC_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CA_fit
      CA_fit = CA
C
*     FUNCTION CB_fit
      CB_fit = CB + 1.6
C
*     FUNCTION CC_fit
      CC_fit = CC + 0.3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

