C
C------------------------------------------------------
C
C     Problem:    DEGEN_M
C
C     Date:       09.03.02
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      tau = 100
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      theta, x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x2
C
*     FUNCTION x2_t
      x2_t = tau**2*x1 - (tau**2 + theta**2)*sin(theta*t)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0
C
*     FUNCTION x2_0
      x2_0 = pi
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
c sin(pi*t)
C
*     FUNCTION x2_fit
      x2_fit = x2
c pi*cos(pi*t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

