C
C------------------------------------------------------
C
C     Problem:    DEGEN
C
C     Date:       21.02.96
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
      mue = 50
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      p, y1, y2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1p
      y1p = y2*pi
C
*     FUNCTION y2p
      y2p = mue*mue*y1/pi - (mue*mue + p*p)*sin(p*t)/pi
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y10
      y10 = 0
C
*     FUNCTION y20
      y20 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

