C
C------------------------------------------------------
C
C     Problem:    DEACTENZ
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V=1          
      F=0.1        
      ENZ0=0.05    
      SUB0=140    
      S01=0       
      S02=0        
      S03=0       
      KINH=6.85   
      KD=0.001    
      S0=1        
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      TLAG, KMICH, VMAX, S1, E1, S2, E2, S3, E3, P, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION S1P
      TAU=V/F 
      KM=KMICH/SUB0       
      KI=KINH/SUB0         
      R1=VMAX*E1*S1/(S1+KM+S1*S1/KI)  
      S1P=(S0-S1)/TAU-R1  
C
*     FUNCTION E1P
      E1P=-KD*E1  
C
*     FUNCTION S2P
      R2=VMAX*E2*S2/(S2+KM+S2*S2/KI)  
      S2P=(S1-S2)/TAU-R2  
C
*     FUNCTION E2P
      E2P=-KD*E2  
C
*     FUNCTION S3P
      R3=VMAX*E3*S3/(S3+KM+S3*S3/KI)  
      S3P=(S2-S3)/TAU-R3  
C
*     FUNCTION E3P
      E3P=-KD*E3  
C
*     FUNCTION PP
      PP=F*(1.0-S3)   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION S1_0
      S1_0=S01
C
*     FUNCTION E1_0
      E10=ENZ0*EXP(-2.0*KD*TLAG) 
      E1_0=E10
C
*     FUNCTION S2_0
      S2_0=S02
C
*     FUNCTION E2_0
      E20=ENZ0*EXP(-KD*TLAG)     
      E2_0=E20
C
*     FUNCTION S3_0
      S3_0=S03
C
*     FUNCTION E3_0
      E30=ENZ0      
      E3_0=E30
C
*     FUNCTION P_0
      P_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION S1_fit
      S1_fit=S1
C
*     FUNCTION E1_fit
      E1_fit=E1
C
*     FUNCTION S2_fit
      S2_fit=S2
C
*     FUNCTION E2_fit
      E2_fit=E2
C
*     FUNCTION S3_fit
      S3_fit=S3
C
*     FUNCTION E3_fit
      E3_fit=E3
C
*     FUNCTION P_fit
      P_fit=P
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
