C
C------------------------------------------------------
C
C     Problem:    DEACT
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V   = 10           
      F   = 0.1           
      Cc0 = 20       
      Ca0 = 500   
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k, ki, kd, Ca, Cc, Cp, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Ca_t
      TAU  = V/F             
      rp   = k*Cc*Ca/(1 + ki*Ca)
      Ca_t = (Ca0 - Ca)/TAU - rp 
C
*     FUNCTION Cc_t
      Cc_t = -kd*Cc 
C
*     FUNCTION Cp_t
      Cp_t = rp - Cp/TAU 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ca_0
      IF (t.LT.1) THEN
        Ca_0 = Ca0
      ELSE
        Ca_0 = Ca
      ENDIF
C
*     FUNCTION Cc_0
      Cc_0 = Cc0
C
*     FUNCTION Cp_0
      IF (t.LT.1) THEN
        Cp_0 = 0
      ELSE
        Cp_0 = Cp
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION rate
      rate = k*Cc*Ca/(1 + ki*Ca)
C      
*     FUNCTION Ca_FIT
      Ca_FIT = Ca  
C
*     FUNCTION Cc_FIT
      Cc_FIT = Cc
C
*     FUNCTION Cp_FIT
      Cp_FIT = Cp
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
