C
C------------------------------------------------------
C
C     Problem:    DC_TUBE
C
C     Date:       09.11.1995
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..7
C
C------------------------------------------------------
C
*     REAL CONSTANT
      L = 15
      Dinnen = 0.0295
      eps = 1.0
      rho = 1250  
      cP = 2000
      MW_Amid = 0.161
      MW_NaOH = 0.04   
      v0 = 1.0
      C10_Amid = 0.237821
      C10_NaOH = 0.075321
      TWand = 423.15
      Temp10 = 423.15
      lam = 1
      k0 = 1.615249E-6
      E_R  = 5666.2
      Temp1 = 423.15
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      Dax, C1, dC1_z, d2C1_zz, f, f_z, z , t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux
      flux = Dax/eps*dC1_z - v0/eps*C1 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION dC1_t
      A = C10_NaOH/MW_NaOH - C10_Amid/MW_Amid
      k= k0*dexp(-E_R/Temp1)
      r=k*C1/MW_Amid*(A + C1/MW_Amid)
      dC1_t = f_z + r*MW_Amid
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION C10
      C10 = C10_Amid/2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
C*     FUNCTION VP
C      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
C*     FUNCTION V0
C      V0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an 
C     area, etc.:
C
c*     FUNCTION UT
c      UT = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION Lz1
      Lz1 = (C1-c10_Amid)*v0/Dax
C
*     FUNCTION Rz1
      Rz1 = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit(i), i in ind
      fit(i) = C1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
