C
C------------------------------------------------------
C
C     Problem:    DCMDEG
C
C     Date:       13.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      F = 0.5
      CSF0 = 0
      CSG = 10
      R = 36
      CO2EQ = 7.63
      VT  = 0.8
      VR  = 1.5
      YSO  = 4.3
      VMAX = 500
      DCMKLA = 6
      EPSILO = 1
      CSRIN0=0
      COIN0=0
      CHIN=1E-7
      PHIN = -0.434*(LOG(CHIN))
      TAU = (VR/6)*EPSILO/R
      CSEQ = 8.1*CSG
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      O2Kla, KS, KI, KO2
      CO1, CO2, CO3, CO4, CO5, CO6
      CSR1, CSR2, CSR3, CSR4, CSR5, CSR6
      CH1, CH2, CH3, CH4, CH5, CH6
      COIN, CSRIN, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CO1P
      PH1 = -0.434*(LOG(ABS(CH1)))
      PH2 = -0.434*(LOG(ABS(CH2)))
      PH3 = -0.434*(LOG(ABS(CH3)))
      PH4 = -0.434*(LOG(ABS(CH4)))
      PH5 = -0.434*(LOG(ABS(CH5)))
      PH6 = -0.434*(LOG(ABS(CH6)))
      RS1 = VMAX*CSR1*CO1/((KS+CSR1+(CSR1*CSR1/KI))*(KO2+CO1))
      RO1 = RS1/YSO
      RS2 = VMAX*CSR2*CO2/((KS+CSR2+(CSR2*CSR2/KI))*(KO2+CO2))
      RO2 = RS2/YSO
      RS3 = VMAX*CSR3*CO3/((KS+CSR3+(CSR3*CSR3/KI))*(KO2+CO3))
      RO3 = RS3/YSO
      RS4 = VMAX*CSR4*CO4/((KS+CSR4+(CSR4*CSR4/KI))*(KO2+CO4))
      RO4 = RS4/YSO
      RS5 = VMAX*CSR5*CO5/((KS+CSR5+(CSR5*CSR5/KI))*(KO2+CO5))
      RO5 = RS5/YSO
      RS6 = VMAX*CSR6*CO6/((KS+CSR6+(CSR6*CSR6/KI))*(KO2+CO6))
      RO6 = RS6/YSO
      CO1P = ((COIN-CO1)/TAU)-RO1
C
*     FUNCTION CO2P
      CO2P = ((CO1-CO2)/TAU)-RO2
C
*     FUNCTION CO3P
      CO3P = ((CO2-CO3)/TAU)-RO3
C
*     FUNCTION CO4P
      CO4P = ((CO3-CO4)/TAU)-RO4
C
*     FUNCTION CO5P
      CO5P = ((CO4-CO5)/TAU)-RO5
C
*     FUNCTION CO6P
      CO6P = ((CO5-CO6)/TAU)-RO6
C
*     FUNCTION CSR1P
      CSR1P = ((CSRIN-CSR1)/TAU)-RS1
C
*     FUNCTION CSR2P
      CSR2P = ((CSR1-CSR2)/TAU)-RS2
C
*     FUNCTION CSR3P
      CSR3P = ((CSR2-CSR3)/TAU)-RS3
C
*     FUNCTION CSR4P
      CSR4P = ((CSR3-CSR4)/TAU)-RS4
C
*     FUNCTION CSR5P
      CSR5P = ((CSR4-CSR5)/TAU)-RS5
C
*     FUNCTION CSR6P
      CSR6P = ((CSR5-CSR6)/TAU)-RS6
C
*     FUNCTION CH1P
      CH1P = ((CHIN-CH1)/TAU)+(2*RS1/84.9e3)
C
*     FUNCTION CH2P
      CH2P = ((CH1-CH2)/TAU)+(2*RS2/84.9e3)
C
*     FUNCTION CH3P
      CH3P = ((CH2-CH3)/TAU)+(2*RS3/84.9e3)
C
*     FUNCTION CH4P
      CH4P = ((CH3-CH4)/TAU)+(2*RS4/84.9e3)
C
*     FUNCTION CH5P
      CH5P = ((CH4-CH5)/TAU)+(2*RS5/84.9e3)
C
*     FUNCTION CH6P
      CH6P = ((CH5-CH6)/TAU)+(2*RS6/84.9e3)
C
*     FUNCTION COINP
      COINP = ((R/VT)*(CO6-COIN))+(O2KLA*(CO2EQ-COIN))
C
*     FUNCTION CSRINP
      CSRINP=((R/VT)*(CSR6-CSRIN))
     /        +(DCMKLA*(CSEQ-CSRIN))+((F/VT)*(CSF0-CSRIN))
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION CO1_0
      CO1_0 = 0
C
*     FUNCTION CO2_0
      CO2_0 = 0
C
*     FUNCTION CO3_0
      CO3_0 = 0
C
*     FUNCTION CO4_0
      CO4_0 = 0
C
*     FUNCTION CO5_0
      CO5_0 = 0
C
*     FUNCTION CO6_0
      CO6_0 = 0
C
*     FUNCTION CSR1_0
      CSR1_0 = 0
C
*     FUNCTION CSR2_0
      CSR2_0 = 0
C
*     FUNCTION CSR3_0
      CSR3_0 = 0
C
*     FUNCTION CSR4_0
      CSR4_0 = 0
C
*     FUNCTION CSR5_0
      CSR5_0 = 0
C
*     FUNCTION CSR6_0
      CSR6_0 = 0
C
*     FUNCTION CH1_0
      CH1_0 = CHIN
C
*     FUNCTION CH2_0
      CH2_0 = CHIN
C
*     FUNCTION CH3_0
      CH3_0 = CHIN
C
*     FUNCTION CH4_0
      CH4_0 = CHIN
C
*     FUNCTION CH5_0
      CH5_0 = CHIN
C
*     FUNCTION CH6_0
      CH6_0 = CHIN
C
*     FUNCTION COIN_0
      COIN_0 = COIN0
C
*     FUNCTION CSRIN_0
      CSRIN_0 = CSRIN0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION CO6_fit
      CO6_fit = CO6
C
*     FUNCTION CSR6_fit
      CSR6_fit = CSR6
C
*     FUNCTION CH6_fit
      CH6_fit = CH6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
