C
C------------------------------------------------------
C
C     Problem:    DCIMMIGR
C
C     Date:       22.07.2007
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, c, d, N, Y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION N_t
      IF (t.LT.d) THEN
        N_t = c 
      ELSE
        N_t = c + a*N - b*N*Y
      ENDIF
C
*     FUNCTION Y_t
      Y_t = N    
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION N_0
      IF (t.lt.1) THEN
        N_0 = 0
      ELSE 
        N_0 = N
      ENDIF  
C
*     FUNCTION Y_0
      IF (t.lt.1) THEN
        Y_0 = 0
      ELSE 
        Y_0 = Y
      ENDIF  
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION N_fit   
      N_fit = N
C
*     FUNCTION Y_fit
      Y_fit = Y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C