C
C------------------------------------------------------
C
C     Problem:  DA_X
C
C     Date:     26.07.96
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Vh = 0.05
      Vn = 1.28
      Vg = 15.2 - Vn
      F0_initial = 0.026
      M0_initial = 13.5173
C
C------------------------------------------------------
C
*     SPLINE S_INT
      0.0    52.0
      3.0    53.5
      10.0   53.5
      20.0   53.5
      30.0   52.8
      40.0   53.3
      50.0   53.5
      60.0   52.8
      70.0   52.8
      80.0   52.9
      90.0   53.5 
      100.0  53.1         
      110.0  53.3
      120.0  52.7
      130.0  52.3
      140.0  52.5
      150.0  52.8
      160.0  52.9
      170.0  52.8
      180.0  52.9 
      190.0  52.8 
      200.0  52.4
      201.0  51.8
      202.0  53.3
      203.0  51.9
      204.0  52.2 
      205.0  52.9
      206.0  52.6
      207.0  52.3
      208.0  52.7
      209.0  52.4 
      210.0  52.2
      211.0  53.0
      212.0  52.2
      213.0  52.9
      214.0  52.6
      215.0  52.7
      216.0  51.9
      217.0  52.6
      218.0  52.6 
      219.0  53.2
      220.0  52.5
      221.0  52.5
      222.0  52.3
      223.0  52.7
      224.0  52.7
      225.0  52.4
      226.0  52.4
      227.0  52.8
      228.0  52.3
      229.0  52.1
      230.0  52.5
      231.0  52.5
      232.0  52.4
      233.0  52.7
      234.0  52.5
      235.0  52.2
      236.0  52.8
      237.0  52.6
      238.0  51.7
      239.0  52.4
      240.0  52.0
      242.0  51.1
      243.0  52.6
      244.0  52.2
      245.0  51.4
      246.0  52.0
      247.0  51.9
      248.0  48.9
      249.0  43.3
      250.0  5.4
      251.0  5.5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      L0, L1, G0, G1, Shot
C
C------------------------------------------------------
C
C   - Fitting criteria:
C   
*     FUNCTION z
      i = 0
      DL = L0
      DG = G0
      D = 1/DL - 1/DG
      If (D .Eq. 0) Then
        GoTo 1004
      EndIf
      F = F0_initial
      M = M0_initial
      L = (Vg - M/DG)/D
      z_init = F/(F + L)
      If (L .Gt. M) Then
        GoTo 1003
      EndIf
 1000 Continue   
      z = F/(F + L)
      i = i + 1
      s = S_INT(i)*0.001 
      F = F - z*s
      M = M - (1 - z)*s
      DL = L1*i*0.01 + L0
      DG = G1*i*0.01 + G0
      If (DL .Eq. 0) Then
        GoTo 1005
      EndIf
      If (DG .Eq. 0) Then
        GoTo 1006
      EndIf
      D = 1/DL - 1/DG
      If (D .Eq. 0) Then
        GoTo 1004
      EndIf
      G = (M/DL - Vg)/D
      L = (Vg - M/DG)/D
      If (i .Lt. Shot) Then
        GoTo 1000
      Endif
      GoTo 9999
C
 1003 Continue
      z = 2000
      GoTo 9999
 1004 Continue
      z = 3000
      GoTo 9999
 1005 Continue
      z = 4000
      GoTo 9999
 1006 Continue
      z = 5000
C
 9999 Continue
      z = z/z_init*S_int(Shot)/52*100/DL
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


