C
C------------------------------------------------------
C
C     Problem:    DAE_IN2X
C
C     Date:       12.02.99
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 10
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      x10, a, b, c, x1, x2, z, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = (alpha - 1/(a - t))*x1 + (a - t)*alpha*z
     /        + (b - t)/(a - t)*exp(t) 
C
*     FUNCTION x2_t
      x2_t = (1 - alpha)/(t - a)*x1 - x2 + (alpha - 1)*z 
     /        + a*exp(t)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION alg_equ
      alg_equ = (t + a)*x1 + (t**2 - c)*x2 - (t**2 + t 
     /         - a)*exp(t)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = x10
C
*     FUNCTION x2_0
      x2_0 = a*(x10 + 1)/c
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION z_0
      z_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1 - x10*exp(t)
C
*     FUNCTION x2_fit
      x2_fit = x2 - a*(x10 + 1)/c*exp(t)
C
*     FUNCTION z_fit
      z_fit = z + exp(t)/(a - t)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



