C
C------------------------------------------------------
C
C     Problem:    DAE_I3
C
C     Date:       21.10.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      S2 = SQRT(2)
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      A, OMEGA, P1, P2, P3, P4, LAMBDA, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION P1_t
      P1_t = P3
C
*     FUNCTION P2_t
      P2_t = P4
C
*     FUNCTION P3_t
      P3_t = A*LAMBDA*P1
C
*     FUNCTION P4_t
      P4_t = A*LAMBDA*P2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION ALG
      ALG = 1 - P1**2 - P2**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION P1_0
      P1_0 = 1/S2
C
*     FUNCTION P2_0
      P2_0 = 1/S2
C
*     FUNCTION P3_0
      P3_0 = OMEGA/S2
C
*     FUNCTION P4_0
      P4_0 = -OMEGA/S2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION LAMBDA_0
      LAMBDA_0 = -OMEGA**2/2
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit_1
      fit_1 = P1
C
*     FUNCTION fit_2
      fit_2 = P2
C
*     FUNCTION ALG_I3
      ALG_I3 = 1 - P1**2 - P2**2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

