C
C------------------------------------------------------
C
C     Problem:    CYC_COM1
C
C     Date:       06.01.2003
C
C------------------------------------------------------
C          
*     REAL CONSTANT
      CyD = 0.01625
      D0 = 0.00065
C
C------------------------------------------------------
C          
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      k, Kc, t
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION DA                         
      A = k*(2 + Kc*CyD)/(1 + Kc*CyD)
      DA = D0*(1 - exp(-A*t))/(2 + Kc*CyD)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


