C
C------------------------------------------------------
C
C     Problem:    CUSP
C
C     Date:       04.07.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      epsS, sigmaS, y, a, b, y_x, a_x, b_x, y_xx, a_xx, b_xx
      yx, ax, bx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION y_t
      eps = epsS*0.0001
      sigma = sigmaS*0.001
      y_t = -(y**3 + a*y + b)/eps + sigma*y_xx
C
*     FUNCTION a_t
      u = (y - 0.7)*(y - 1.3)
      v = u/(u + 0.1)
      a_t = b + 0.07*v + sigma*a_xx
C
*     FUNCTION b_t
      b_t = (1 - a**2)*b - a - 0.4*y + 0.035*v + sigma*b_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION y_0
      y_0 = 0
C
*     FUNCTION a_0
      a_0 = -2*cos(2*pi*x)
C
*     FUNCTION b_0
      b_0 = 2*sin(2*pi*x)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION equ1
      equ1 = yx - y_x
C
*     FUNCTION equ2
      equ2 = ax - a_x
C
*     FUNCTION equ3
      equ3 = bx - b_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION yx_0
      yx_0 = 0
C
*     FUNCTION ax_0
      ax_0 = 0
C
*     FUNCTION bx_0
      bx_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_right
c      u_right = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION y_x_left
      y_x_left = yx
C
*     FUNCTION a_x_left
      a_x_left = ax
C
*     FUNCTION b_x_left
      b_x_left = bx
C
*     FUNCTION y_x_right
      y_x_right = yx
C
*     FUNCTION a_x_right
      a_x_right = ax
C
*     FUNCTION b_x_right
      b_x_right = bx
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = a
C
*     FUNCTION fit2
      fit2 = b
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





