C
C------------------------------------------------------
C
C   Problem:    CUO
C  
C   Date:       21.2.2005
C      
C------------------------------------------------------
C
*     REAL CONSTANT
      A   = 3240
      V   = 888
      Q   = 12000
      tau = 0.083
C      
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (ka0,ka1,kd0,kd1,x0)
C     2. variables identifying solution of ordinary
C        differential equations (x,BX,CX)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, X0, I0
      X, BX, CX
      I, t
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t
      X_t = tau*(-2*k1*I*X**2 + 2*k2*BX**2)
C
*     FUNCTION BX_t
      BX_t = tau*(2*k1*I*X**2 - 2*k2*BX**2 - k3*I*BX + k4*CX)
C    
*     FUNCTION CX_t
      CX_t = -(X_t + BX_t)     
C
*     FUNCTION I_t
      I_t = -I + A*tau/V*(k2*BX**2 + k4*CX - k1*I*X - K3*I*BX) 
     
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0 = X0
C
*     FUNCTION BX_0
      BX0 = X0*(k1/k2)**0.5
      BX_0 = BX0
C
*     FUNCTION CX_0
      CX0 = k3/k4*BX_0
      CX_0 = CX0
C
*     FUNCTION I_0
      I_0 = I0

C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION I_fit
      I_fit = I
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1
      g1 = 1.8 - 0.5*(BX_0 + CX_0) - CX_0 
C
*     END     
C
C------------------------------------------------------
C