C
C------------------------------------------------------
C
C     Problem:    CTFLOW
C
C     Date:       18.12.97
C
C------------------------------------------------------
C
*     REAL CONSTANT
      hL = 1
      hV = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      k, xL, xV, L, V, xL_z, xV_z, L_z, V_z, 
     /   xL_zz, xV_zz, L_zz, V_zz, z, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION xL_t
      xL_t = (L_z*xL + L*xL_z + k*(xV - xL))/hL
C
*     FUNCTION xV_t
      xV_t = -(V_z*xV + V*xV_z + k*(xV - xL))/hV
C
*     FUNCTION algL
      algL = L_z + k*(xV - xL)
C
*     FUNCTION algV
      algV = V_z + k*(xV - xL)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION xL_0
      xL_0 = 0.8
C
*     FUNCTION xV_0
      xV_0 = 0.5
C
*     FUNCTION L_0
      L_0 = 0.8
C
*     FUNCTION V_0
      V_0 = 1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION VP
c      VP = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION V0
c      V0 =...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION xV_left
      xV_left = 0.5
C
*     FUNCTION V_left
      V_left = 2
C
*     FUNCTION xL_right
      xL_right = 0.8
C
*     FUNCTION L_right
      L_right = 1
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT1
      FIT1 = xL
C
*     FUNCTION FIT2
      FIT2 = xV
C
*     FUNCTION FIT3
      FIT3 = xL
C
*     FUNCTION FIT4
      FIT44 = xV
C
*     FUNCTION FIT5
      FIT5 = xL
C
*     FUNCTION FIT6
      FIT6 = xV
C
*     FUNCTION FIT7
      FIT7 = xL
C
*     FUNCTION FIT8
      FIT8 = xV
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
