C
C------------------------------------------------------
C
C     Problem:    CS_REAC
C
C     Date:       04.11.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      cA0 = 5.0
      cB0 = 0.8
      theta0 = -243.0
      thetaK0 = -250.0
      rho = 0.9342E-4
      Cp = 3.01
      HRAB = 4.2
      HRBC = -11.0
      HRAD = -41.85
      kW = 4032.0
      AR = 0.215
      VR = 1.0
      mK = 5.0
      CPK = 2.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      V, QK, cA, cB, theta, thetaK, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cA_p
      k1 = 50.603
      k2 = k1
      k3 = 6.74
      cA_p = V*(cA0 - cA) - k1*cA - k3*cA**2
C
*     FUNCTION cB_p
      cB_p = -V*cB + k1*cA - k2*cB
C
*     FUNCTION theta_p
      theta_p = V*(theta0 - theta) - (k1*cA*HRAB + k2*cB*HRBC 
     /          + k3*cA**2*HRAD)/(rho*Cp)
     /          + kW*AR*(thetaK - theta)/(rho*Cp*VR)
C
*     FUNCTION thetaK_p
      thetaK_p = (QK + kW*AR*(theta - thetaK))/(mK*CPK)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cA_0
      cA_0 = cA0
C
*     FUNCTION cB_0
      cB_0 = cB0
C
*     FUNCTION theta_0
      theta_0 = theta0
C
*     FUNCTION thetaK_0
      thetaK_0 = thetaK0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cA_fit
      cA_fit = cA
C
*     FUNCTION cB_fit
      cB_fit = cB
C
*     FUNCTION theta_fit
      theta_fit = theta
C
*     FUNCTION thetaK_fit
      thetaK_fit = thetaK
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






