C
C------------------------------------------------------
C
C     Problem:    CSTR_JY0
C
C     Date:       31.3.2006
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Q        = 1000     
      Cs12_10  = 1  
      Cs12_50  = 1.1 
      Cs12_151 = 1.1     
C            
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ka, kd, V, A, H
      Cg1, Cs1, Cg2, Cs2
      t
C
C------------------------------------------------------
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Cg1_t  
      if (t.le.151) then 
        I1 = 1 - Cg1
      else
        I1 = -Cg1
      endif  
      Cg1_t = Q/V*I1 + A*(kd*H*Cs1 - ka*Cg1)
C
*     FUNCTION Cs1_t    
      if (t.le.151) then 
        I2 = 1 - Cg1
      else
        I2 = -Cg1
      endif  
      Cs1_t = -V/A/H*Cg1_t + Q/A/H*(I2)
C
*     FUNCTION Cg2_t
      Cg2_t = Q/V*(Cg1 - Cg2) + A*(kd*H*Cs2 - ka*Cg2)
C
*     FUNCTION Cs2_t
      Cs2_t = -V/A/H*Cg2_t + Q/A/H*(Cg1 - Cg2)   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Cg1_0
      if (t.eq.0) then
        Cg1_0 = 0
      else
        Cg1_0 = Cg1
      endif    
C
*     FUNCTION Cs1_0
      if (t.eq.0) then
        Cs1_0 = 0
      else
        Cs1_0 = Cs1
      endif    
C
*     FUNCTION Cg2_0
      if (t.eq.0) then
        Cg2_0 = 0
      else
        Cg2_0 = Cg2
      endif    
C
*     FUNCTION Cs2_0
      if (t.eq.0) then
        Cs2_0 = 0
      else
        Cs2_0 = Cs2
      endif  
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Cg2_fit
      Cg2_fit = Cg2 
C
*     FUNCTION Cg1_fit
      Cg1_fit = Cg1 
C      
*     FUNCTION Cs1_fit
      Cs1_fit = Cs1 
C
*     FUNCTION Cs2_fit
      Cs2_fit = Cs2 
C
C------------------------------------------------------
C
C   - Constraints (if exist): 
C
C------------------------------------------------------
   
*     END
C------------------------------------------------------
