C
C------------------------------------------------------
C
C     Problem:    CSTR_DFT
C
C     Date:       2.5.2006
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Cgin1 = 0.00311
      Cgin2 = 0.0168 
      Cgin3 = 0.03058
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ka, kd, V, A, Q, alpha, beta, gama, p 
      Cg1, Cg2, Cg3 
      t
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations: 
C           
*     FUNCTION Cg1_t               
      Cg1_t = -Q/V*Cg1 + A*(kd*Cg1 - alpha*ka*abs(Cg1)**p)/V 
C
*     FUNCTION Cg2_t   
      Cg2_t = -Q/V*Cg2 + A*(kd*Cg2 - beta*ka*abs(Cg2)**p)/V      
C
*     FUNCTION Cg3_t   
      Cg3_t = -Q/V*Cg3 + A*(kd*Cg3 - gama*ka*abs(Cg3)**p)/V

C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0): 
C
*     FUNCTION Cg1_0
      Cg1_0 = Cgin1
C
*     FUNCTION Cg2_0
      Cg2_0 = Cgin2
C
*     FUNCTION Cg3_0
      Cg3_0 = Cgin3
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Cg1_fit
      Cg1_fit = Cg1 
C
*     FUNCTION Cg2_fit
      Cg2_fit = Cg2 
C
*     FUNCTION Cg3_fit
      Cg3_fit = Cg3        
C
C------------------------------------------------------
C
C   - Constraints: 
C
*     FUNCTION g1 
      g1 = kd*Cg1 - alpha*ka*Cg1**2  
C      
*     FUNCTION g2 
      g2 = kd*Cg2 - beta*ka*Cg2**2
C
*     FUNCTION g3 
      g3 = kd*Cg3 - gama*ka*Cg3**2  
C
C------------------------------------------------------
   
*     END
C------------------------------------------------------