C
C------------------------------------------------------
C
C     Problem:    CSTR_CTL
C
C     Date:       13.11.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..20
C
C------------------------------------------------------
C
*     INDEX
      i
C
C------------------------------------------------------
C
*     REAL CONSTANT
      q = 0.1
      rhocp = 659
      k0 = 3.3E-10
      V = 1
      mdHr = 20000
      Tin = 290
      kw = 0.1
      EA = 20000
      cin = 6.666
      Fk = 250
      R = 12.9864
      a1 = q/V
      a2 = kw*Fk/(rhocp*V)
      a3 = mdHr/rhocp
      a4 = EA/R     
C
C------------------------------------------------------
C
*     TABLE tct(j), j in ind
      1    5.0
      2   10.0
      3   15.0
      4   20.0
      5   25.0
      6   30.0
      7   35.0
      8   40.0
      9   45.0
      10  50.0
      11  55.0
      12  60.0
      13  65.0
      14  70.0
      15  75.0
      16  80.0
      17  85.0
      18  90.0
      19  95.0
      20 100.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u(j), j in ind
      c, T, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION c_t
      K = k0*exp(a4/T)
      c_t = a1*(cin - c) - 2*K*c**2
C
*     FUNCTION T_t
      i = 1
 1000 continue
      if (time.le.tct(i)) then     
        Tk = u(i)
        goto 1100
      endif
      i = i+1
      goto 1000
 1100 continue
      T_t = a1*(Tin - T) + a2*(Tk - T) - a3*K*c**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c_0
      if (time.lt.1) then
        c_0 = 3.3
      else
        c_0 = c
      endif
C
*     FUNCTION T_0
      if (time.lt.1) then
        T_0 = 355
      else
        T_0 = T
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c_fit
      c_fit = c
C
*     FUNCTION T_fit
      T_fit = T
C
*     FUNCTION Tk_ctrl
      i = 1
 2000 continue
      if (time.le.tct(i)) then     
        Tk_ctrl = u(i)
        goto 2100
      endif
      i = i+1
      goto 2000
 2100 continue
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
