C
C
C------------------------------------------------------
C
C     Problem:    CSTR_BM
C
C     Date:       2.8.1999
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      V = 18.83
      cA0 = 5.1   
      T0 = 130   
      HRAB = 4.2
      HRBC = -11
      HRAD = -41.85
      rho = 0.9342
      AR = 0.215
      kW = 4032
      mK = 5 
      VR = 1 
      QK = -4495.7
C
C------------------------------------------------------
C           
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, Cp, CPK, cA, cB, T, TK, time
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cA_t
      kT1 = k1*10**12*exp(-9758.3/(T + 273.15))
      kT2 = kT1
      kT3 = k2*10**9*exp(-8560/(T + 273.15))
      cA_t = V*(cA0 - cA) - kT1*cA - kT3*cA**2
C
*     FUNCTION cB_t
      cB_t = -V*cB + kT1*cA - kT2*cB
C
*     FUNCTION T_t
      T_t = V*(T0 - T) - (kT1*cA*HRAB + kT2*cB*HRBC 
     /                      + kT3*cA**2*HRAD)/(rho*Cp)
     /         + kW*AR/(rho*Cp*VR)*(TK - T) 
C
*     FUNCTION TK_t
      TK_t = (QK + kW*AR*(T - TK))/(mK*CPK) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION cA_0
      cA_0 = 1.235
C
*     FUNCTION cB_0
      cB_0 = 0.9    
C
*     FUNCTION T_0
      T_0 = 134.14
C
*     FUNCTION TK_0
      TK_0 = 134.14
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cA_fit
      cA_fit = cA
C
*     FUNCTION cB_fit
      cB_fit = cB
C
*     FUNCTION T_fit
      T_fit = T
C
*     FUNCTION TK_fit
      TK_fit = TK
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

