C
C------------------------------------------------------
C
C     Problem:    CSTRCOM
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      A0=0.4
      B0=0.6
      X0=0
      Y0=0
      Z0=0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, K2, K3, A, B, X, Y, Z, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      TAU=5000
      IF (T.GT.10000) THEN
        TAU = 10000
      ENDIF
      AP=(A0-A)/TAU-K1*A*B
C
*     FUNCTION BP
      BP=(B0-B)/TAU-K1*A*B-K2*X*B-K3*Y*B
C
*     FUNCTION XP
      XP=(X0-X)/TAU+K1*A*B-K2*X*B
C
*     FUNCTION YP
      YP=(Y0-Y)/TAU+K2*B*X-K3*B*Y
C
*     FUNCTION ZP
      ZP=(Z0-Z)/TAU+K3*B*Y
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A_0
      IF (T.LT.1) THEN
        A_0=A0
      ELSE
        A_0=A
      ENDIF
C
*     FUNCTION B_0
      IF (T.LT.1) THEN
        B_0=B0
      ELSE
        B_0=B
      ENDIF
C
*     FUNCTION X_0
      IF (T.LT.1) THEN
        X_0=X0
      ELSE
        X_0=X
      ENDIF
C
*     FUNCTION Y_0
      IF (T.LT.1) THEN
        Y_0=Y0
      ELSE
        Y_0=Y
      ENDIF
C
*     FUNCTION Z_0
      IF (T.LT.1) THEN
        Z_0=Z0
      ELSE
        Z_0=Z
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION AFIT
      AFIT=A
C
*     FUNCTION BFIT
      BFIT=B
C
*     FUNCTION XFIT
      XFIT=X
C
*     FUNCTION YFIT
      YFIT=Y
C
*     FUNCTION ZFIT
      ZFIT=Z
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

