C
C------------------------------------------------------
C
C     Problem:    CSTR
C
C     Date:       24.01.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      C0 = 1
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      TAU, K, C1, C2, C3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION C1P
      C1P = (C0-C1)/TAU-K*C1
C
*     FUNCTION C2P
      C2P = (C1-C2)/TAU-K*C2
C
*     FUNCTION C3P
      C3P = (C2-C3)/TAU-K*C3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C10
      C10 = 0
C
*     FUNCTION C20
      C20 = 0
C
*     FUNCTION C30
      C30 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X1
      X1 = (C0-C1)/C0
C
*     FUNCTION X2
      X2 = (C0-C2)/C0
C
*     FUNCTION X3
      X3 = (C0-C3)/C0
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

