C----------------------------------------------------------------
C
C     Problem:  CSTOHNE
C
C----------------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      ke, kf, I0, Ns, Is , I, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION NsP
      NsP = kf*Is
C
*     FUNCTION IsP
      IsP = -kf*Is - ke*Is
C
*     FUNCTION IP
      IP = ke*Is
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ns0
      Ns0 = 0
C 
*     FUNCTION Is0
      Is0 = I0
C
*     FUNCTION I_0
      I_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT_P
      FIT_P = Is + Ns 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C