C
C------------------------------------------------------
C
C     Problem:    CR_ELO
C
C     Date:       10/15/98
C
C------------------------------------------------------
C
*     REAL CONSTANT
      P0 = 115.5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, k, Cs0, P, Ps, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION P_t
      Wp = 5.33*(k*P - a*Ps*exp(-b*Ps))
      P_t = -1.4683*P + Wp 
C
*     FUNCTION Cs_t
      Cs_t = Wp/5.33
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION P_0
      P_0 = P0
C
*     FUNCTION Ps_0
      Ps_0 = Cs0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION P_fit
      P_fit = P
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
