C
C------------------------------------------------------
C
C     Problem:    CRYSTAL
C
C     Date:       30.03.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k = 1 
      K1 = 3E-7
      w = 1
      v0 = 0.0005
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      q, D, c1, c2, u, v, u_x, v_x, u_xx, v_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u1_t
      v1t = k*(u*c1 - w*K1)
      u1_t = D*u_xx - q*u_x - v1t
C
*     FUNCTION v1_t
      v1_t = 0
C
*     FUNCTION u2_t
      v2t = k*(u*c2 - w*K1)
      u2_t = D*u_xx - q*u_x - v2t
C
*     FUNCTION v2_t
      v2_t = v2t
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION u1_0
      u1_0 = c1
C
*     FUNCTION v1_0
      v1_0 = 0
C
*     FUNCTION u2_0
      u2_0 = c1
C
*     FUNCTION v2_0
      v2_0 = v0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u1_left
      u1_left = c1
C
*     FUNCTION u2_left
      u2_left = u
C
*     FUNCTION u2_right
      u2_right = c2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u1_x_right
      u1_x_right = u_x
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = u
C
*     FUNCTION fit2
      fit2 = u
C
*     FUNCTION fit3
      fit3 = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


