C
C------------------------------------------------------
C
C     Problem:    CRANE
C
C     Date:       31.5.1999
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
*     MACRO u1
      u1 = u11 + u12*t + u13*t**2 + u14*t**3 
C
*     MACRO u2
      if (t.lt.5.5) then
        u2=0
      else
        u2 = u21*(t - 5.5)
      endif
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      u11, u12, u13, u14
      u21
      x1, x2, x3, x4, x5, x6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = x4
C
*     FUNCTION x2_t
      x2_t = x5
C
*     FUNCTION x3_t
      x3_t = x6
C
*     FUNCTION x4_t
      x4_t = u1 + 17.2656*x3
C
*     FUNCTION x5_t
      x5_t = u2
C
*     FUNCTION x6_t
      x6_t = -(u1 + 27.0756*x3 + 2*x5*x6)/x2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      if (t.lt.1) then
        x1_0 = 0
      else
        x1_0 = x1
      endif
C
*     FUNCTION x2_0
      if (t.lt.1) then
        x2_0 = 22
      else
        x2_0 = x2
      endif
C
*     FUNCTION x3_0
      if (t.lt.1) then
        x3_0 = 0
      else
        x3_0 = x3
      endif
C
*     FUNCTION x4_0
      if (t.lt.1) then
        x4_0 = 0
      else
        x4_0 = x4
      endif
C
*     FUNCTION x5_0
      if (t.lt.1) then
        x5_0 = -1
      else
        x5_0 = x5
      endif
C
*     FUNCTION x6_0
      if (t.lt.1) then
        x6_0 = 0
      else
        x6_0 = x6
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x3
C
*     FUNCTION x2_fit
      x2_fit = x6
C
*     FUNCTION u1_fit
      u1_fit = 0.1*u1
C
*     FUNCTION u2_fit
      u2_fit = 0.1*u2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


