C
C------------------------------------------------------
C
C     Problem:    CPL_ADV
C
C     Date:       9.12.1999
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a1, a2, u1, u2, u1_x, u2_x, u1_xx, u2_xx, 
     /          v1, v2, f1, f2, f1_x, f2_x, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
*     FUNCTION flux1
      flux1 = -a1*u2
C
*     FUNCTION flux2
      flux2 = -a2*u1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u1_t
      u1_t = f1_x
C
*     FUNCTION u2_t
      u2_t = f2_x
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 1
C
*     FUNCTION u2_0
      if (x.lt.0.5) then
        u2_0 = 1
      else
        u2_0 = 0
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
*     FUNCTION v1_t
      v1_t = f1_x
C
*     FUNCTION v2_t
      v2_t = f2_x
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
*     FUNCTION v1_0
      v1_0 = 1
C
*     FUNCTION v2_0
      v2_0 = 1
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u1_left
      u1_left = v1
C
*     FUNCTION u2_left
      u2_left = v2
C
*     FUNCTION u1_right
      u1_right = v1 - 0.25
C
*     FUNCTION u2_right
      u2_right = 1.25 - v2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
C*     FUNCTION u_x_left
C      u_x_left = ...
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit1
      fit1 = u1
C
*     FUNCTION fit2
      fit2 = u2
C
*     FUNCTION fit3
      fit3 = u1
C
*     FUNCTION fit4
      fit4 = u2
C
*     FUNCTION fit5
      fit5 = u1
C
*     FUNCTION fit6
      fit6 = u2
C
*     FUNCTION fit7
      fit7 = u1
C
*     FUNCTION fit8
      fit8 = u2
C
*     FUNCTION fit9
      fit9 = u1
C
*     FUNCTION fit10
      fit10 = u2
C
*     FUNCTION fit11
      fit11 = u1
C
*     FUNCTION fit12
      fit12 = u2
C
*     FUNCTION fit13
      fit13 = u1
C
*     FUNCTION fit14
      fit14 = u2
C
*     FUNCTION fit15
      fit15 = u1
C
*     FUNCTION fit16
      fit16 = u2
C
*     FUNCTION fit17
      fit17 = u1
C
*     FUNCTION fit18
      fit18 = u2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


