C 
C------------------------------------------------------
C
C     Problem:    CPA_PLAS
C
C     Date:       06.12.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      yma  = 3450
      F = 500
      hma = 0.052
      u0 = yma/(F*hma)
      Vp = 197.51
      k12 = 0.054         
      P = 1
      scale1 = 1e-6
      scale2 = 1e-6
      scale3 = 1e-1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C         solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D1, D2, D3, u, u_x, u_xx, y1, y2, x, time
C 
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_p
      u1_p = D1*scale1*u_xx
C
*     FUNCTION u2_p
      u2_p = D2*scale2*u_xx
C
*     FUNCTION u3_p
      u3_p = D3*scale3*u_xx 
C      
C ---------------------------------------------------
C
c 
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = u0
C 
*     FUNCTION u2_0
      u2_0 = 0
C
*     FUNCTION u3_0
      u3_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C   coupled ordinary differential equations:
c 
*     FUNCTION y1_p
      y1_p = -F*D3*scale3*u_x-k12*y1
C
*     FUNCTION y2_p
      y2_p = k12*y1
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y1_0
      y1_0 = 0
C
*     FUNCTION y2_0
      y2_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C 
*     FUNCTION u2_left
      u2_left = P*u
C
*     FUNCTION u3_left
      u3_left = u
C
*     FUNCTION u3_right
      u3_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients first at left
C     borders of all areas, then at right borders of all 
C     areas:
C 
*     FUNCTION u1_x_left
      u1_x_left=0
c
*     FUNCTION u1_x_right
      u1_x_right = D2*scale2/(D1*scale2)*u_x
C
*     FUNCTION u2_x_right
      u2_x_right = D3*scale3/(D2*scale2)*u_x
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = y1/Vp
C
*     FUNCTION fit2
      fit2 = y2
C
*     FUNCTION fit3
      fit3 = F*simpsn(1,1)
C
*     FUNCTION fit4
      fit4 = F*simpsn(1,2)
C
*     FUNCTION fit5
      fit5 = F*simpsn(1,3)
C
*     FUNCTION fit6
      fit6 = fit3+fit4+fit5+y1+y2
C
*     FUNCTION fit7
      fit7 = fit3+fit4+y1+y2
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
