C
C------------------------------------------------------
C
C     Problem:    CO_OXYD
C
C     Date:       20.02.2002
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..4
C
C------------------------------------------------------
C
*     LININT u0
      0.0    0.1
      10.0   0.15
      20.0   0.05
      30.0   0.02
      40.0   0.05
      50.0   0.02
      60.0   0.00
      70.0   0.01
      80.0   0.05
      90.0   0.01
      100.0  0.02
C
*     LININT v0
      0.0    0.0
      10.0   0.01
      20.0   0.02
      30.0   0.02
      40.0   0.01
      50.0   0.005
      60.0   0.01
      70.0   0.05
      80.0   0.05
      90.0   0.01
      100.0  0.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables identifying solution of coupled
C        differential algebraic equations, e.g. implicit
C        boundary conditions (w)
C     7. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDAE.
C     8. spatial variable (x)
C     9. time variable (t)
C
*     VARIABLE
      eps, a, b, u, v, u_x, v_x, u_xx, v_xx, r1, r2, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = u*(u - 1)*(u - (b + v)/a)/eps + u_xx
C
*     FUNCTION v_t
      if (u.le.0.33333) then
        h = 0
      else
      if (u.le.1) then
        h = 1 - 6.75*u*(1 - u)**2
      else
        h=1
      endif
      endif 
      v_t = h - v
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u_0
      u_0 = u0(x)
C
*     FUNCTION v_0
      v_0 = v0(x)
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
C*     FUNCTION v_t
C      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
C*     FUNCTION v_0
C      v_0 = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled differential algebraic equations, order 
C     defined by increasing spatial positions (e.g. 
C     implicit boundary conditions):
C
*     FUNCTION equ1
      equ1 = u_x - r1
C
*     FUNCTION equ2
      equ2 = u - r2
C
C------------------------------------------------------
C
C   - Initial values of system of coupled differential
C     algebraic equations for t=0 in the same order:
C
*     FUNCTION r1_0
      r1_0 = 0
C
*     FUNCTION r2_0
      r2_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
*     FUNCTION u_left
      u_left = r2
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u_x_right
      u_x_right = r1
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
