C
C------------------------------------------------------
C
C     Problem:    COPPER_D
C
C     Date:       09.06.2005
C
C------------------------------------------------------
C
*     REAL CONSTANT
      AR = 3930.0
      V  = 900.0
      Q  = 36000.0
      k1 = 1E5
      k2 = 100
C            
C------------------------------------------------------
C
C    - Independent variables in the following order:
C     1. parameters to be estimated (k1,k2,k3,k4,x0)
C     2. variables identifying solution of ordinary
C        differential equations 
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k3, k4, m
      X, BX0, BX1, BX2, BX3, BX4, BX5, BX6, BX7, BX8, BX9, BX10, BX11,
     /                       BX12, BX13, BX14, BX15, BX16, BX17, BX18
      I, t
C
C------------------------------------------------------
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t
      X_t = k2*BX0**2 - k1*I*X**2
C
*     FUNCTION BX0_t
      BX0_t = k1*I*X**2 + k4*BX1 - k2*BX0**2 - k3*I*BX0
C    
C
*     FUNCTION BX1_t
      BX1_t = k3*I*BX0 + k4*BX2  - k4*BX1 - k3*I*BX1
C
C
*     FUNCTION BX2_t
      BX2_t = k3*I*BX1 + k4*BX3 - k4*BX2 - k3*I*BX2
C
*     FUNCTION BX3_t
      BX3_t = k3*I*BX2 + k4*BX4 - k4*BX3 - k3*I*BX3
C
*     FUNCTION BX4_t
      BX4_t = k3*I*BX3 + k4*BX5 - k4*BX4 - k3*I*BX4
C
*     FUNCTION BX5_t
      BX5_t = k3*I*BX4 + k4*BX6 - k4*BX5 - k3*I*BX5
C
*     FUNCTION BX6_t
      BX6_t = k3*I*BX5 + k4*BX7 - k4*BX6 - k3*I*BX6
C
*     FUNCTION BX7_t
      BX7_t = k3*I*BX6 + k4*BX8 - k4*BX7 - k3*I*BX7
C
*     FUNCTION BX8_t
      BX8_t = k3*I*BX7 + k4*BX9 - k4*BX8 - k3*I*BX8
C
*     FUNCTION BX9_t
      BX9_t = k3*I*BX8 + k4*BX10 - k4*BX9 - k3*I*BX9
C
*     FUNCTION BX10_t
      BX10_t = k3*I*BX9 + k4*BX11 - k4*BX10 - k3*I*BX10
C
*     FUNCTION BX11_t
      BX11_t = k3*I*BX10 + k4*BX12 - k4*BX11 - k3*I*BX11
C
*     FUNCTION BX12_t
      BX12_t = k3*I*BX11 + k4*BX13 - k4*BX12 - k3*I*BX12
C
*     FUNCTION BX13_t
      BX13_t = k3*I*BX12 + k4*BX14 - k4*BX13 - k3*I*BX13
C
*     FUNCTION BX14_t
      BX14_t = k3*I*BX13 + k4*BX15 - k4*BX14 - k3*I*BX14
C
*     FUNCTION BX15_t
      BX15_t = k3*I*BX14 + k4*BX16 - k4*BX15 - k3*I*BX15
C
*     FUNCTION BX16_t
      BX16_t = k3*I*BX15 + k4*BX17 - k4*BX16 - k3*I*BX16
C
*     FUNCTION BX17_t
      BX17_t = k3*I*BX16 + k4*BX18 - k4*BX17 - k3*I*BX17 
C
*     FUNCTION BX18_t
      BX18_t = k3*I*BX17 + k4*(1-X-BX0-BX1-BX2-BX3-BX4-BX5-BX6-BX7-
     /         BX8-BX9-BX10-BX11-BX12-BX13-BX14-BX15-BX16-BX17-BX18)- 
     /        k4*BX18 - k3*I*BX18
C
*     FUNCTION I_t
      if (t.lt.71.2178) then 
        I1 = 1 - I
      else
        I1 = -I
      endif  
      I_t = I1 + AR*m*(0.5*k2*BX0**2 + k4*(1 -X -BX0) 
     /      - 0.5*k1*I*X**2 - k3*I*BX0 - k3*I*BX1 
     /      - k3*I*BX2 - k3*I*BX3 - k3*I*BX4 - k3*I*BX5 
     /      - k3*I*BX6 - k3*I*BX7 - k3*I*BX8 - k3*I*BX9 
     /      - k3*I*BX10 - k3*I*BX11 - k3*I*BX12 - k3*I*BX13 
     /      - k3*I*BX14 - k3*I*BX15 - k3*I*BX16 
     /      - k3*I*BX17 - k3*I*BX18)/V 
     
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      if (t.lt.1) then
        X_0 = 1.0
      else
        X_0 = X
      endif    
C
*     FUNCTION BX0_0
      if (t.lt.1) then
        BX0_0 = 0.0
      else
        BX0_0 = BX0
      endif    
C
*     FUNCTION BX1_0
      if (t.lt.1) then
        BX1_0 = 0.0
      else
        BX1_0 = BX1
      endif    
C
*     FUNCTION BX2_0
      if (t.lt.1) then
        BX2_0 = 0.0
      else
        BX2_0 = BX2
      endif    
C
*     FUNCTION BX3_0
      if (t.lt.1) then
        BX3_0 = 0.0
      else
        BX3_0 = BX3
      endif    
C
*     FUNCTION BX4_0
      if (t.lt.1) then
        BX4_0 = 0.0
      else
        BX4_0 = BX4
      endif    
C
*     FUNCTION BX5_0
      if (t.lt.1) then
        BX5_0 = 0.0
      else
        BX5_0 = BX5
      endif    
C
*     FUNCTION BX6_0
      if (t.lt.1) then
        BX6_0 = 0.0 
      else
        BX6_0 = BX6
      endif    
C
*     FUNCTION BX7_0
      if (t.lt.1) then
        BX7_0 = 0.0
      else
        BX7_0 = BX7
      endif    
C
*     FUNCTION BX8_0
      if (t.lt.1) then
        BX8_0 = 0.0
      else
        BX8_0 = BX8
      endif    
C
*     FUNCTION BX9_0
      if (t.lt.1) then
        BX9_0 = 0.0
      else
        BX9_0 = BX9
      endif    
C
*     FUNCTION BX10_0
      if (t.lt.1) then
        BX10_0 = 0.0
      else
        BX10_0 = BX10
      endif    
C
*     FUNCTION BX11_0
      if (t.lt.1) then
        BX11_0 = 0.0
      else
        BX11_0 = BX11
      endif    
C
*     FUNCTION BX12_0
      if (t.lt.1) then
        BX12_0 = 0.0
      else
        BX12_0 = BX12
      endif    
C
*     FUNCTION BX13_0
      if (t.lt.1) then
        BX13_0 = 0.0
      else
        BX13_0 = BX13
      endif    
C
*     FUNCTION BX14_0
      if (t.lt.1) then
        BX14_0 = 0.0
      else
        BX14_0 = BX14
      endif    
C
*     FUNCTION BX15_0
      if (t.lt.1) then
        BX15_0 = 0.0
      else
        BX15_0 = BX15
      endif    
C
*     FUNCTION BX16_0
      if (t.lt.1) then
        BX16_0 = 0.0
      else
        BX16_0 = BX16
      endif    
C
*     FUNCTION BX17_0
      if (t.lt.1) then
        BX17_0 = 0.0
      else
        BX17_0 = BX17
      endif    
C
*     FUNCTION BX18_0
      if (t.lt.1) then
        BX18_0 = 0.0 
      else
        BX18_0 = BX18
      endif    
C
*     FUNCTION I_0
      if (t.lt.1) then
        I_0 = 0.0
      else
        I_0 = I
      endif    
C 
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION I_fit
      I_fit = I     
C------------------------------------------------------
C
C   - Constraints (if exist):
C 
C      g = ...
C
*     END
C------------------------------------------------------

