C
C------------------------------------------------------
C
C     Problem:    COPPER1
C
C     Date:       06.07.2005
C
C------------------------------------------------------
C
*     REAL CONSTANT
      AR = 3140.0
      V  = 888.0
      Q  = 12000.0
C
C------------------------------------------------------
C
*     VARIABLE
      k1, k2, k3, k4, m
      X, BX0, BX1, BX2, BX3, I, u, t
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X_t
      X_t = k2*BX0 - k1*I*X**2
C
*     FUNCTION BX0_t
      BX0_t = k1*I*X**2 + k4*BX1 - k2*BX0 - k3*I*BX0
C    
C
*     FUNCTION BX1_t
      BX1_t = k3*I*BX0 + k4*BX2  - k4*BX1 - k3*I*BX1
C
*     FUNCTION BX2_t
      BX2_t = k3*I*BX1 + k4*BX3 - k4*BX2 - k3*I*BX2
C
*     FUNCTION BX3_t
      BX3_t = k3*I*BX2   - k4*BX3  
C
*     FUNCTION I_t 
      I_t = 1 - I + AR*m*(0.5*k2*BX0 + k4*(BX1+BX2+BX3) -  
     /      0.5*k1*I*X**2 - k3*I*(BX0+BX1+BX2))/V 
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION  equ
      equ = u + AR*m*(0.5*k2*BX0 + k4*(BX1+BX2+BX3) -  
     /      0.5*k1*I*X**2 - k3*I*(BX0+BX1+BX2))/V 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0
      X_0 = 1.0
C
*     FUNCTION BX0_0
      BX0_0 = 0.0
C 
*     FUNCTION BX1_0
      BX1_0 = 0.0
C
*     FUNCTION BX2_0
      BX2_0 = 0.0
C
*     FUNCTION BX3_0
      BX3_0 = 0.0    
C
*     FUNCTION I_0
      I_0 = 0.0    
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION u_0
      u_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u_fit
      u_fit = u
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C